<?php
/*--------------------------------------------------------------------
 OnGetShippingLinkEventListener.php 2020-2-24
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Shop\Product\ShippingLink\Listener;

use Gambio\Shop\SellingUnit\Database\Unit\Events\Interfaces\OnGetProductInfoEventInterface;
use Gambio\Shop\SellingUnit\Database\Unit\Events\Interfaces\OnGetShippingLinkEventInterface;
use Gambio\Shop\SellingUnit\Database\Unit\Events\OnGetShippingLinkEvent;
use Gambio\Shop\SellingUnit\Unit\ValueObjects\ShippingLink;
use main_ORIGIN;

/**
 * Class OnGetShippingLinkEventListener
 * @package Gambio\Shop\Product\ShippingLink\Listener
 */
class OnGetShippingLinkEventListener
{
    /**
     * @var main_ORIGIN
     */
    protected $main;
    
    
    /**
     * OnGetShippingLinkEventListener constructor.
     *
     * @param main_ORIGIN $main
     */
    public function __construct(main_ORIGIN $main)
    {
        $this->main = $main;
    }
    
    
    /**
     * @param OnGetShippingLinkEventInterface $event
     */
    public function __invoke(OnGetShippingLinkEventInterface $event)
    {
        $productId = $event->productId();
        $xtcPrice  = $event->xtcPrice();
        $value     = '';
        
        if ($xtcPrice !== null && $xtcPrice->gm_check_price_status($productId->value())) {
            
            $value = $this->main->getShippingLink(true, $productId->value());
        }
        
        $event->setShippingLink(new ShippingLink($value));
    }
}